/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.AbstractPathReference;
import com.aptana.editor.php.internal.indexer.CallPath;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.FunctionPathReference;
import com.aptana.editor.php.internal.indexer.StaticPathReference;
import com.aptana.editor.php.internal.indexer.VariablePHPEntryValue;
import com.aptana.editor.php.internal.indexer.VariablePathReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org2.eclipse.php.core.compiler.PHPFlags;

public final class PHPTypeProcessor {
    private static final int MAX_REC_DEPTH = 10;

    public static Set<String> processTypes(Set<Object> encodedTypes, IElementsIndex indexer) {
        HashSet<String> result = new HashSet<String>();
        PHPTypeProcessor.processTypes(encodedTypes, result, indexer, 0);
        return result;
    }

    private static Set<String> processTypes(Set<Object> encodedTypes, IElementsIndex indexer, int depth) {
        HashSet<String> result = new HashSet<String>();
        PHPTypeProcessor.processTypes(encodedTypes, result, indexer, depth);
        return result;
    }

    public static Set<String> getCustomTypes(Set<String> types) {
        HashSet<String> result = new HashSet<String>();
        for (String type : types) {
            if (PHPTypeProcessor.isBuiltInType(type)) continue;
            result.add(type);
        }
        return result;
    }

    public static boolean isBuiltInType(String type) {
        if ("_boolean".equals(type)) {
            return true;
        }
        if ("_string".equals(type)) {
            return true;
        }
        if ("_integer".equals(type)) {
            return true;
        }
        if ("_real".equals(type)) {
            return true;
        }
        return "_system".equals(type);
    }

    private static void processTypes(Set<Object> encodedTypes, Set<String> result, IElementsIndex indexer, int depth) {
        if (depth >= 10) {
            return;
        }
        for (Object type : encodedTypes) {
            Set<Object> dispatcherTypes;
            AbstractPathReference ref;
            if (type == null) continue;
            if (type instanceof String) {
                String typeStr = type.toString();
                if (typeStr.startsWith("\\")) {
                    typeStr = typeStr.substring(1);
                }
                result.add(typeStr);
                continue;
            }
            if (type instanceof VariablePathReference) {
                ref = (VariablePathReference)type;
                dispatcherTypes = ((VariablePathReference)ref).getDispatcherTypes();
                PHPTypeProcessor.procesPathReference(dispatcherTypes, ref.getPath(), result, indexer, depth + 1, false);
                continue;
            }
            if (type instanceof FunctionPathReference) {
                ref = (FunctionPathReference)type;
                List<IElementEntry> entries = indexer.getEntries(2, ((FunctionPathReference)ref).getFunctionEntryPath());
                for (IElementEntry entry : entries) {
                    Set<Object> dispatcherTypes2 = PHPTypeProcessor.getEntryDispatcherTypes(entry);
                    if (dispatcherTypes2 == null || dispatcherTypes2.isEmpty()) continue;
                    PHPTypeProcessor.procesPathReference(dispatcherTypes2, ref.getPath(), result, indexer, depth + 1, false);
                }
                continue;
            }
            if (!(type instanceof StaticPathReference)) continue;
            ref = (StaticPathReference)type;
            dispatcherTypes = ((StaticPathReference)ref).getDispatcherTypes();
            PHPTypeProcessor.procesPathReference(dispatcherTypes, ref.getPath(), result, indexer, depth + 1, false);
        }
    }

    private static void procesPathReference(Set<Object> dispatcherTypes, CallPath path, Set<String> result, IElementsIndex indexer, int depth, boolean staticsOnly) {
        if (depth >= 10) {
            return;
        }
        if (dispatcherTypes == null || dispatcherTypes.isEmpty()) {
            return;
        }
        Set<Object> encodedRefTypes = dispatcherTypes;
        Set<String> decodedRefTypes = PHPTypeProcessor.processTypes(encodedRefTypes, indexer, depth + 1);
        Set<String> customRefTypes = PHPTypeProcessor.getCustomTypes(decodedRefTypes);
        if (customRefTypes.isEmpty()) {
            return;
        }
        if (path == null || path.getSize() == 0) {
            result.addAll(customRefTypes);
            return;
        }
        CallPath.Entry firstPathEntry = path.getEntries().get(0);
        for (String type : customRefTypes) {
            String entryName = firstPathEntry.getName();
            String entryPath = String.valueOf(type) + '/' + entryName;
            int category = -1;
            if (firstPathEntry instanceof CallPath.VariableEntry) {
                category = 3;
            } else if (firstPathEntry instanceof CallPath.MethodEntry) {
                category = 2;
            }
            List<IElementEntry> entries = indexer.getEntries(category, entryPath);
            for (IElementEntry entry : entries) {
                Set<Object> entryTypes;
                if (staticsOnly && !PHPTypeProcessor.isStaticEntry(entry) || (entryTypes = PHPTypeProcessor.getEntryDispatcherTypes(entry)) == null || entryTypes.isEmpty()) continue;
                CallPath subPath = path.subPath(1);
                if (subPath.getSize() != 0) {
                    PHPTypeProcessor.procesPathReference(entryTypes, subPath, result, indexer, depth + 1, false);
                    continue;
                }
                PHPTypeProcessor.processTypes(entryTypes, result, indexer, depth + 1);
            }
        }
    }

    private static Set<Object> getEntryDispatcherTypes(IElementEntry entry) {
        Object val = entry.getValue();
        if (val instanceof VariablePHPEntryValue) {
            VariablePHPEntryValue entryValue = (VariablePHPEntryValue)val;
            return entryValue.getTypes();
        }
        if (val instanceof FunctionPHPEntryValue) {
            FunctionPHPEntryValue entryValue = (FunctionPHPEntryValue)val;
            return entryValue.getReturnTypes();
        }
        return null;
    }

    private static boolean isStaticEntry(IElementEntry entry) {
        Object entryValue = entry.getValue();
        if (entryValue instanceof AbstractPHPEntryValue) {
            int modifiers = ((AbstractPHPEntryValue)entryValue).getModifiers();
            return PHPFlags.isStatic((int)modifiers);
        }
        return false;
    }

    private PHPTypeProcessor() {
    }
}

